#ifndef __MidiVizMain__
#define __MidiVizMain__

/**
 * @file MidiVizMain.h
 * @brief Main function for the MidiViz vst
 *
 * @date 28/01/2006
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
 * This file forms part of the example projects for the Infinity API.\n
 * You may not redistribute either the source code or the compiled binary.\n
 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 *
 * $Id: MidiVizMain.cpp,v 1.7 2007/02/11 02:20:17 paul Exp $
 */

#include "CMidiViz.hpp"
#include <Exceptions/CException.hpp>
#include <Host/CApplication.hpp>

//	===========================================================================

using Exponent::MidiViz::CMidiViz;
using Exponent::Host::CApplication;
using Exponent::Exceptions::CException;

//	===========================================================================

static AudioEffect *effect = 0;		/**< The audio effect that we will return. Never quite understood why it has to be static, but there you go */

//	===========================================================================

#if MAC
	#pragma export on
#endif

//	===========================================================================

// prototype of the export function main
#ifdef WIN32
	AEffect *main (audioMasterCallback audioMaster);
#else
	#define main main_macho
	extern "C" AEffect *main_macho (audioMasterCallback audioMaster);
#endif

AEffect *main (audioMasterCallback audioMaster)
{
	try
	{
		// Setup the mac application information
#ifndef WIN32
		START_EXPONENT_API("Exponent", "MidiViz", "Vst Midi Tool", "1.0.0", "com.exponent.midiviz", "Copyright Exponent Digital 2006, all rights reserved");
#endif
		// Check that the VST version matches
		if (!audioMaster (0, audioMasterVersion, 0, 0, 0, 0))
		{
			return 0;
		}

		// Create a new GFlux
		effect = new CMidiViz(audioMaster);

		// Check that we have a valid effect
		if (!effect)
		{
			return 0;
		}

		// Return the audio effect
		return effect->getAeffect ();
	}
	catch(CException theException)
	{
		CDialog::notifyUser("Caught exception in main function of MidiViz. Cannot continue to load", "Exception occurred", true);
	}
	catch(...)
	{
		CDialog::notifyUser("Caught exception in main function of MidiViz. Cannot continue to load", "Exception occurred", true);
	}
	return 0;
}

//	===========================================================================

#if MAC
	#pragma export off
#endif

//	===========================================================================

#if WIN32
#include <windows.h>
BOOL WINAPI DllMain (HINSTANCE hInstance, DWORD dwReason, LPVOID lpvReserved)
{
	// Check its an attatch process call
	if (dwReason == DLL_PROCESS_ATTACH)
	{
		START_EXPONENT_API(hInstance, "Exponent", "MidiViz", "Vst Midi Tool", "1.0.0", "Software\\Exponent\\MidiViz", "Copyright Exponent Digital 2006, all rights reserved");
	}
	else if (dwReason == DLL_PROCESS_DETACH)
	{
		 STOP_EXPONENT_API_NO_LOG;
	}
	return 1;
}
#endif	// WIN32
#endif	// MidiVizMain